/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers;

import dev.xkmc.modulargolems.compat.materials.cataclysm.CataclysmProxy;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.block.state.BlockState;

public class NetheriteMonstrosityEarthquakeModifier
extends AttributeGolemModifier {
    public static final double RANGE = 5.0;

    public NetheriteMonstrosityEarthquakeModifier() {
        super(1, new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ATTACK, () -> 5.0), new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ARMOR, () -> 5.0), new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_TOUGH, () -> 5.0));
    }

    @Override
    public void onRegisterFlag(Consumer<GolemFlags> cons) {
        cons.accept(GolemFlags.EARTH_QUAKE);
    }

    @Override
    public void handleEvent(AbstractGolemEntity<?, ?> golem, int value, byte event) {
        if (event == 83) {
            NetheriteMonstrosityEarthquakeModifier.makeParticles(golem, 0.0f, 0.0f);
        }
    }

    public static void performEarthQuake(AbstractGolemEntity<?, ?> golem) {
        NetheriteMonstrosityEarthquakeModifier.earthQuake(golem);
        golem.m_9236_().m_7605_(golem, (byte)83);
    }

    public static void earthQuake(LivingEntity le) {
        le.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + le.m_217043_().m_188501_() * 0.1f);
        for (LivingEntity entity : le.m_9236_().m_45976_(LivingEntity.class, le.m_20191_().m_82400_(7.0))) {
            if (le.m_7307_((Entity)entity) || entity == le) continue;
            float damage = (float)(le.m_21133_(Attributes.f_22281_) + (double)(entity.m_21233_() * CataclysmProxy.earthquakeDamage()));
            boolean flag = entity.m_6469_(le.m_269291_().m_269333_(le), damage);
            if (!flag) continue;
            NetheriteMonstrosityEarthquakeModifier.launch(le, (Entity)entity);
        }
    }

    public static void makeParticles(LivingEntity le, float vec, float math) {
        if (le.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 80 + le.m_217043_().m_188503_(12); ++i1) {
                double DeltaMovementX = le.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = le.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = le.m_217043_().m_188583_() * 0.07;
                float f = Mth.m_14089_((float)(le.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(le.f_20883_ * ((float)Math.PI / 180)));
                float angle = (float)Math.PI / 180 * le.f_20883_ + (float)i1;
                double extraX = 2.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 2.0f * Mth.m_14089_((float)angle);
                double theta = (double)le.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.0);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(le.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)le.m_20186_());
                int hitZ = Mth.m_14107_((double)(le.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = le.m_9236_().m_8055_(hit.m_7495_());
                le.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), le.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), le.m_20186_() + extraY, le.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private static void launch(LivingEntity le, Entity e) {
        double d0 = e.m_20185_() - le.m_20185_();
        double d1 = e.m_20189_() - le.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        float f = 2.0f;
        e.m_5997_(d0 / d2 * (double)f, 0.75, d1 / d2 * (double)f);
    }
}

